--> NOTA : requte pour version 2012 et suivantes.
WITH
T_INDEX_A_CREER AS
(
SELECT 'CREATE INDEX X_' + CONVERT(CHAR(8), CURRENT_TIMESTAMP, 112)
       + '_' + REPLACE(CAST(NEWID() AS VARCHAR(38)), '-', '_')
       + ' ON ' + statement
       + '(' + COALESCE(equality_columns + ', ' + inequality_columns, equality_columns, inequality_columns) + ')'
       + COALESCE(' INCLUDE (' + included_columns +')', '')
       + ' WITH (FILLFACTOR = 90);' AS COMMANDE_SQL,
       PERCENT_RANK() OVER(ORDER BY avg_user_impact * user_seeks DESC) * 100.0 AS RANG
FROM   sys.dm_db_missing_index_details AS mid
       INNER JOIN sys.dm_db_missing_index_groups AS mig
             ON mid.index_handle = mig.index_handle
       INNER JOIN sys.dm_db_missing_index_group_stats AS migs
             ON mig.index_group_handle = migs.group_handle
)
SELECT COMMANDE_SQL
FROM   T_INDEX_A_CREER
WHERE  RANG <= 20;


--> NOTA : requte pour version 2008 R2 et prcdentes.
WITH
T_INDEX_A_CREER AS
(
SELECT 'CREATE INDEX X_' + CONVERT(CHAR(8), CURRENT_TIMESTAMP, 112)
       + '_' + REPLACE(CAST(NEWID() AS VARCHAR(38)), '-', '_')
       + ' ON ' + statement
       + '(' + COALESCE(equality_columns + ', ' + inequality_columns, equality_columns, inequality_columns) + ')'
       + COALESCE(' INCLUDE (' + included_columns +')', '')
       + ' WITH (FILLFACTOR = 90);' AS COMMANDE_SQL,
       RANK() OVER(ORDER BY avg_user_impact * user_seeks DESC) * 100.0 AS RANG,
	   COUNT(*) OVER() AS NOMBRE
FROM   sys.dm_db_missing_index_details AS mid
       INNER JOIN sys.dm_db_missing_index_groups AS mig
             ON mid.index_handle = mig.index_handle
       INNER JOIN sys.dm_db_missing_index_group_stats AS migs
             ON mig.index_group_handle = migs.group_handle
)
SELECT COMMANDE_SQL
FROM   T_INDEX_A_CREER
WHERE  RANG <= NOMBRE * 0.2;
